#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'
require_relative '../../pages/landing_appointments'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../pages/user_menu'
require_relative '../../module/database/OracleUtility'


describe '[Story# VAR-2781: Update User Guide and Link]
          [Story# VAR-4079: update front-end version number to 3.1.0]
          [Story# VAR-9428: Automate Version Number Update 4.2.0]
          [Story# VAR-9561: Automate Version Number Update 4.1.1]
          [Story# VAR-9710: Automate Version Number Update 4.1.2]
          [Story# VAR-11483: Version update to VAR 4.2.7]
          [Story# VAR-11889: Version update to VAR 4.4.0]
          [Story# VAR-9890: Create new Release Branch]
          [Story# VAR-5444: On the About Page PACT expand should "Patient Aligned Care Team]'  do
  include DriverUtility
  include OracleUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @eula = Eula.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @modal = Modal.new(@driver)
    APPOINTMENTS = "Appointments/Requests"

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-2885|TC#VAR-2932: Update User guide and Link]
           [AC#VAR-4148|TC#VAR-4149: Validate app version]
           [AC#VAR-5151|TC#VAR-5152: Validate Automate Version Number Update]'do
    it "Section/table title: Appointments " do
      @common.loginEndsOnHome(pw_redacted)
      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
      @landing_appointments.primary_header_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)
    end

    it "Verify Footer version number" do
      Watir::Wait.until {@landing.footerUserInfo == "Logged in as userLast01, userFirst01"}
      expect(@landing.appVersion).to eq("VA Appointments - v4.10.0")
      expect(@landing.footerUserInfo).to eq("Logged in as userLast01, userFirst01")
    end

    it "About page content and version update" do
        @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
        button_element = @driver.button(:id => 'user-menu-btn')
        execute_script("$(arguments[0]).click();",button_element)
        @user_menu.about_element.when_visible(TIME_OUT_LIMIT)
        button_element = @driver.button(:id => 'about-btn')
        execute_script("$(arguments[0]).click();",button_element)
        @common.waitWhileSpinnerPresent
        @user_menu.aboutTitle_element.when_present(TIME_OUT_LIMIT)
        expect(@user_menu.aboutTitle).to eq('About')
        expect(@user_menu.appVersion).to eq('Veteran Appointment Requests v4.10.0')
        expect(@user_menu.contentLine1).to eq('The app is intended to allow Veterans to')
        expect(@user_menu.contentLine2).to eq('Directly schedule Primary Care appointments in facilities where a Veteran has a Patient Aligned Care Team (PACT)')
        expect(@user_menu.contentLine3).to eq('Request Primary Care and Mental Health appointments')
        expect(@user_menu.contentLine4).to eq('View or Cancel Booked Appointments')
    end

    it "Click ok to about page" do
        @user_menu.ok
        @landing_appointments.primary_header_element.when_visible(TIME_OUT_LIMIT)
        expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)
    end

  end
end









